package game;


public class CustomNpcBehaviorWorkroom {
	
	private boolean isSolid;
	private boolean shouldInjure;
	private int maxMoveSpeedX;
	private int maxMoveSpeedY;
	
	private int movementGoalMode;
	
	private boolean doesGravityApply;
	private boolean canMoveThroughBlocks;
	
	private int playerBulletReceiveMode;
	private int enemyBulletReceiveMode;
	
	private CustomImageDataII images[];
	
	private boolean drawOverPlayer;
	private boolean drawOverStaticBlocks;
	private boolean drawOverRogueBlocks;
	
	private CustomNpcBehaviorSwitchRule swithRules[];
	
	public CustomNpcBehavior create(CustomNpcBehaviorFactoryParm parm) {
		
		
		CustomNpcBehavior returnValue = new CustomNpcBehavior(images,
															  drawOverPlayer,
															  drawOverStaticBlocks,
															  drawOverRogueBlocks,
															  swithRules,
															  playerBulletReceiveMode,
															  enemyBulletReceiveMode,
															  doesGravityApply,
															  canMoveThroughBlocks,
															  isSolid,
															  shouldInjure,
															  maxMoveSpeedX,
															  maxMoveSpeedY,
															  parm.getMoveMode(),
															  parm.getMoveParmX(),
															  parm.getMoveParmY(),
															  parm.getMoveParmString());
		
		
		
		return returnValue;
		
	}
	
	
}
